<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;

                    if (empty($columns)) {
                        $columns = [
                           'Order ID', 'Order Status', 
                           'Type', 'Delivery Mode',
                           'Payment Mode', 'Order Date',
                           'Invoice Id', 'Invoice Date',
                           'Customer Name', 'Customer Mobile',
                           'Item Name', 'Item SKU',
                           'Item Price', 'Item Qty',
                           'HSN', 'State',
                           'State Code', 'SGST',
                           'SGST%', 'CGST',
                           'CGST%', 'IGST',
                           'IGST%', 'CESS',
                           'CESS%', 'Item Tax',
                           'Item Total'
                        ];
                    }
                    $query = "
                    SELECT 
                        o.Order_id AS orderid, 
                        o.Invoice_id, 
                        i.invoice_no AS invoiceno,
                        i.created_date AS invoicedate, 
                        o.order_no, 
                        o.user_id, 
                        o.Created_date AS createdate, 
                        o.Total_price, 
                        o.Action_status, 
                        o.Grand_total, 
                        o.Store_status,
                        o.Payment_status,  
                        u.displayname AS customer_name, 
                        u.phoneno AS customer_mobile, 
                        u.address AS Address, 
                        u.city AS City, 
                        u.state AS State, 
                        u.pincode AS Pincode,
                        p.Payment_type,
                        pd.Product_name AS item_name, 
                        pd.SKU AS sku, 
                        pd.HSN, 
                        od.Selling_price AS price, 
                        od.qty AS quantity,
                        od.Product_total
                    FROM 
                        orders o
                    LEFT JOIN 
                        invoice i 
                    ON 
                        o.Invoice_id = i.invoice_id
                    LEFT JOIN 
                        order_data od 
                    ON 
                        o.Order_id = od.Order_id
                    LEFT JOIN
                        product pd 
                    ON 
                        od.Product_id = pd.Product_id
                    LEFT JOIN 
                        payment p 
                    ON 
                        o.Order_id = p.Order_id
                    LEFT JOIN 
                        customer u 
                    ON 
                        o.user_id = u.id
                    WHERE 
                        o.Delete_status = 0";
                
                // Apply duration filters (last week, last month, etc.)
                if ($duration == "Today") {
                    $query .= " AND DATE(o.Created_date) = CURDATE()";
                } elseif ($duration == "Yesterday") {
                    $query .= " AND DATE(o.Created_date) = CURDATE() - INTERVAL 1 DAY";
                } elseif ($duration == "Last Week") {
                    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
                } elseif ($duration == "Last Month") {
                    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
                } elseif ($duration == "Custom" && $startDate && $endDate) {
                    $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
                }
                // Ensure no unnecessary GROUP BY clause
                $query .= " ORDER BY o.Order_id";
                
                // Perform the query using MySQLi
                $result = $conn->query($query);
                $data = [];
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                
                // Generate the CSV file
                if ($reportFormat == "Xlsx") {
                    $filePath = 'reports/order_item_report_' . time() . '.csv';
                    $file = fopen($filePath, 'w');
                
                    if (!$file) {
                        die(json_encode(['status' => 'error', 'message' => 'Unable to create CSV file.']));
                    }
                
                    // Write the header row
                    $header = [];

                    // Dynamically add columns to the header using if (or switch for different scenarios)
                    if (in_array('Order ID', $columns)) $header[] = 'Order Id';
                    if (in_array('Order Status', $columns)) $header[] = 'Order Status';
                    if (in_array('Type', $columns)) $header[] = 'Type';
                    if (in_array('Delivery Mode', $columns)) $header[] = 'Delivery Mode';
                    if (in_array('Payment Mode', $columns)) $header[] = 'Payment Mode';
                    if (in_array('Order Date', $columns)) $header[] = 'Order Date';
                    if (in_array('Invoice Id', $columns)) $header[] = 'Invoice Id';
                    if (in_array('Invoice Date', $columns)) $header[] = 'Invoice Date';
                    if (in_array('Customer Name', $columns)) $header[] = 'Customer Name';
                    if (in_array('Customer Mobile', $columns)) $header[] = 'Customer Mobile';
                    if (in_array('Item Name', $columns)) $header[] = 'Item Name';
                    if (in_array('Item SKU', $columns)) $header[] = 'Item Sku';
                    if (in_array('Item Price', $columns)) $header[] = 'Item Price';
                    if (in_array('Item Qty', $columns)) $header[] = 'Item Qty';
                    if (in_array('HSN', $columns)) $header[] = 'HSN';
                    if (in_array('State', $columns)) $header[] = 'State';
                    if (in_array('State Code', $columns)) $header[] = 'State Code';
                    if (in_array('SGST', $columns)) $header[] = 'SGST';
                    if (in_array('SGST%', $columns)) $header[] = 'SGST%';
                    if (in_array('CGST', $columns)) $header[] = 'CGST';
                    if (in_array('CGST%', $columns)) $header[] = 'CGST%';
                    if (in_array('IGST', $columns)) $header[] = 'IGST';
                    if (in_array('IGST%', $columns)) $header[] = 'IGST%';
                    if (in_array('CESS', $columns)) $header[] = 'CESS';
                    if (in_array('CESS%', $columns)) $header[] = 'CESS%';
                    if (in_array('Item Tax', $columns)) $header[] = 'Item Tax';
                    if (in_array('Item Total', $columns)) $header[] = 'Item Total';
                    
                    // Write the header to the CSV file
                    fputcsv($file, $header);
                
                    // Write data rows
                    foreach ($data as $row) {
                        // Handle Payment Type
                        switch ($row['Payment_type']) {
                            case '1':
                                $paymenttype = "Cash";
                                $paymentmode = "Cash";
                                break;
                            case '2':
                                $paymenttype = "Card";
                                $paymentmode = "Card";
                                break;
                            case '3':
                                $paymenttype = "UPI";
                                $paymentmode = "Bank";
                                break;
                            case '4':
                                $paymenttype = "Bank Transfer";
                                $paymentmode = "Bank";
                                break;
                            case '5':
                                $paymenttype = "Cheque";
                                $paymentmode = "Cheque";
                                break;
                            default:
                                $paymenttype = "N/A";
                                $paymentmode = "N/A";
                        }
                
                        // Handle Action Status
                        $statusMap = [
                            "1" => "New",
                            "2" => "Confirmed",
                            "3" => "Dispatched",
                            "4" => "Delivered",
                            "5" => "Cancelled",
                            "6" => "Completed"
                        ];
                        $label = $statusMap[$row['Action_status']] ?? "Unknown";
                        
                        $statusMap1 = [
                            "1" =>"instore",
                            "2" => "online"
                        ];
                        $label1 = $statusMap1[$row['Store_status']] ?? "Unknown";
                
                        // Tax Calculations
                        $total = $row['Product_total'];
                        $sgst_percent = 2.5;
                        $cgst_percent = 2.5;
                        $igst_percent = 5.0;
                        $sgst = $total * ($sgst_percent / 100);
                        $cgst = $total * ($cgst_percent / 100);
                        $igst = $total * ($igst_percent / 100);
                        $itemtotal = $total + $sgst + $cgst + $igst;
                
                        // Write row to CSV
                      foreach ($data as $row) {
    $rowData = [];

    // Dynamically add values to rowData based on header inclusion
    if (in_array('Order ID', $columns)) $rowData[] = $row['order_no'];
    if (in_array('Order Status', $columns)) $rowData[] = $label;
    if (in_array('Type', $columns)) $rowData[] = $label1;  // Placeholder for 'Type'
    if (in_array('Delivery Mode', $columns)) $rowData[] = ''; // Placeholder for 'Delivery Mode'
    if (in_array('Payment Mode', $columns)) $rowData[] = $paymenttype;
    if (in_array('Order Date', $columns)) $rowData[] = $row['createdate'];
    if (in_array('Invoice Id', $columns)) $rowData[] = $row['invoiceno'];
    if (in_array('Invoice Date', $columns)) $rowData[] = $row['invoicedate'];
    if (in_array('Customer Name', $columns)) $rowData[] = $row['customer_name'];
    if (in_array('Customer Mobile', $columns)) $rowData[] = $row['customer_mobile'];
    if (in_array('Item Name', $columns)) $rowData[] = $row['item_name'];
    if (in_array('Item SKU', $columns)) $rowData[] = $row['sku'];
    if (in_array('Item Price', $columns)) $rowData[] = $row['price'];
    if (in_array('Item Qty', $columns)) $rowData[] = $row['quantity'];
    if (in_array('HSN', $columns)) $rowData[] = $row['HSN'];
    if (in_array('State', $columns)) $rowData[] = $row['State'];
    if (in_array('State Code', $columns)) $rowData[] = ''; // Placeholder for 'State Code'
    if (in_array('SGST', $columns)) $rowData[] = $sgst;
    if (in_array('SGST%', $columns)) $rowData[] = $sgst_percent;
    if (in_array('CGST', $columns)) $rowData[] = $cgst;
    if (in_array('CGST%', $columns)) $rowData[] = $cgst_percent;
    if (in_array('IGST', $columns)) $rowData[] = $igst;
    if (in_array('IGST%', $columns)) $rowData[] = $igst_percent;
    if (in_array('CESS', $columns)) $rowData[] = 0;  // Placeholder for 'CESS'
    if (in_array('CESS%', $columns)) $rowData[] = 0;  // Placeholder for 'CESS%'
    if (in_array('Item Tax', $columns)) $rowData[] = 0;  // Placeholder for 'Item Tax'
    if (in_array('Item Total', $columns)) $rowData[] = $itemtotal;

    // Write the row to the CSV file
    fputcsv($file, $rowData);
}}

// Close the file
fclose($file);
                
                    // Insert report details into the database
                    $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                    $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                    $report_no_result = $conn->query($report_no_query);
                    $max_id = $report_no_result->fetch_assoc()['max_id'] ?? 0;
                    $reportNo = 'REP_' . str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);
                    $durationText = $duration ?? 'N/A';
                    $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                                    VALUES ('$reportNo','Order Item Report', NOW(), '$durationText', '$finalpath', 0)";
                    $conn->query($insertQuery);
                
                    echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
                } 
                 elseif ($reportFormat == "pdf") {
                $filePath = 'reports/order_item_report_' . time() . '.pdf';
                
                // Create a new PDF document
                $pdf = new FPDF('L', 'mm', array(1100, 700));
                
                $pdf->AddPage();
                $pdf->SetFont('Arial', 'B', 12);
                
                // Table headers
                $headers = [
                 'Order Id', 'Order Status', 'Type', 'Delivery Mode', 'Payment Mode', 'Order Date',
                        'Invoice Id', 'Invoice Date', 'Customer Name', 'Customer Mobile', 'Item Name',
                        'Item Sku', 'Item Price', 'Item Qty', 'HSN', 'State', 'State Code', 'SGST', 'SGST%',
                        'CGST', 'CGST%', 'IGST', 'IGST%', 'CESS', 'CESS%', 'Item Tax', 'Item Total'
                ];
                
                // Set column widths
                $colWidths = array_fill(0, count($headers), 40); // Adjust column widths as needed
                $rowHeight = 8;
                
                // Print header row
                foreach ($headers as $index => $header) {
                   $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
                
                // Print data rows
                foreach ($data as $row) {
                        // Handle Payment Type
                        switch ($row['Payment_type']) {
                            case '1':
                                $paymenttype = "Cash";
                                $paymentmode = "Cash";
                                break;
                            case '2':
                                $paymenttype = "Card";
                                $paymentmode = "Card";
                                break;
                            case '3':
                                $paymenttype = "UPI";
                                $paymentmode = "Bank";
                                break;
                            case '4':
                                $paymenttype = "Bank Transfer";
                                $paymentmode = "Bank";
                                break;
                            case '5':
                                $paymenttype = "Cheque";
                                $paymentmode = "Cheque";
                                break;
                            default:
                                $paymenttype = "N/A";
                                $paymentmode = "N/A";
                        }
                
                        // Handle Action Status
                        $statusMap = [
                            "1" => "New",
                            "2" => "Confirmed",
                            "3" => "Dispatched",
                            "4" => "Delivered",
                            "5" => "Cancelled",
                            "6" => "Completed"
                        ];
                        $label = $statusMap[$row['Action_status']] ?? "Unknown";
                        $statusMap1 = [
                            "1" =>"instore",
                            "2" => "online"
                        ];
                        $label1 = $statusMap1[$row['Store_status']] ?? "Unknown";
                
                        // Tax Calculations
                        $total = $row['Product_total'];
                        $sgst_percent = 2.5;
                        $cgst_percent = 2.5;
                        $igst_percent = 5.0;
                        $sgst = $total * ($sgst_percent / 100);
                        $cgst = $total * ($cgst_percent / 100);
                        $igst = $total * ($igst_percent / 100);
                        $itemtotal = $total + $sgst + $cgst + $igst;
                   $values = [
                    $row['order_no'], 
                            $label, 
                            $label1, // Placeholder for 'Type'
                            '', // Placeholder for 'Delivery Mode'
                            $paymenttype, 
                            $row['createdate'], 
                            $row['invoiceno'], 
                            $row['invoicedate'], 
                            $row['customer_name'], 
                            $row['customer_mobile'], 
                            $row['item_name'], 
                            $row['sku'], 
                            $row['price'], 
                            $row['quantity'], 
                            $row['HSN'],
                            $row['State'], 
                            '', // Placeholder for 'State Code'
                            $sgst, 
                            $sgst_percent, 
                            $cgst, 
                            $cgst_percent, 
                            $igst, 
                            $igst_percent, 
                            0, // Placeholder for 'CESS'
                            0, // Placeholder for 'CESS%'
                            0, // Placeholder for 'Item Tax'
                            $itemtotal
                        ];
                
                   foreach ($values as $index => $value) {
                       $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                   }
                   $pdf->Ln(); // Move to the next row
                }
                
                // Save the PDF file
                
                $pdf->Output('F', $filePath);
                $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                $report_no_result = mysqli_query($conn, $report_no_query);
                $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                $durationText = $duration ?? 'N/A';
                $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                              VALUES ('$reportNo','Order Item Report', NOW(), '$durationText', '$finalpath', 0)";
                $conn->query($insertQuery);
                
                echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
                } else {
                echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
                }
                }
            }
 ?>